#include "CombineMode.h"

#include <map>

#define DEFINE_NAMED_COMBINE_MODE(combineMode) {#combineMode, DEFINE_COMBINE_MODE_LERP(combineMode)}

std::map<std::string, ColorCombineMode> gNamedCombineModes = {
    DEFINE_NAMED_COMBINE_MODE(G_CC_PRIMITIVE),
    DEFINE_NAMED_COMBINE_MODE(G_CC_SHADE),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATEI),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATEIA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATEIDECALA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATERGB),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATERGBA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATERGBDECALA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATEI_PRIM),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATEIA_PRIM),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATEIDECALA_PRIM),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATERGB_PRIM),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATERGBA_PRIM),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATERGBDECALA_PRIM),
    DEFINE_NAMED_COMBINE_MODE(G_CC_DECALRGB),
    DEFINE_NAMED_COMBINE_MODE(G_CC_DECALRGBA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_BLENDI),
    DEFINE_NAMED_COMBINE_MODE(G_CC_BLENDIA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_BLENDIDECALA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_BLENDRGBA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_BLENDRGBDECALA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_ADDRGB),
    DEFINE_NAMED_COMBINE_MODE(G_CC_ADDRGBDECALA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_REFLECTRGB),
    DEFINE_NAMED_COMBINE_MODE(G_CC_REFLECTRGBDECALA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_HILITERGB),
    DEFINE_NAMED_COMBINE_MODE(G_CC_HILITERGBA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_HILITERGBDECALA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_SHADEDECALA),
    DEFINE_NAMED_COMBINE_MODE(G_CC_BLENDPE),
    DEFINE_NAMED_COMBINE_MODE(G_CC_BLENDPEDECALA),

/* oddball modes */
    DEFINE_NAMED_COMBINE_MODE(_G_CC_BLENDPE),
    DEFINE_NAMED_COMBINE_MODE(_G_CC_BLENDPEDECALA),
    DEFINE_NAMED_COMBINE_MODE(_G_CC_TWOCOLORTEX),
/* used for 1-cycle sparse mip-maps, primitive color has color of lowest LOD */
    DEFINE_NAMED_COMBINE_MODE(_G_CC_SPARSEST),
    DEFINE_NAMED_COMBINE_MODE(G_CC_TEMPLERP),

/* typical CC cycle 1 modes, usually followed by other cycle 2 modes */
    DEFINE_NAMED_COMBINE_MODE(G_CC_TRILERP),
    DEFINE_NAMED_COMBINE_MODE(G_CC_INTERFERENCE),

/*
 *  One-cycle color convert operation
 */
    DEFINE_NAMED_COMBINE_MODE(G_CC_1CYUV2RGB),

/*
 *  NOTE: YUV2RGB expects TF step1 color conversion to occur in 2nd clock.
 * Therefore, CC looks for step1 results in TEXEL1
 */
    DEFINE_NAMED_COMBINE_MODE(G_CC_YUV2RGB),

/* typical CC cycle 2 modes */
    DEFINE_NAMED_COMBINE_MODE(G_CC_PASS2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATEI2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATEIA2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATERGB2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATERGBA2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATEI_PRIM2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATEIA_PRIM2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATERGB_PRIM2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_MODULATERGBA_PRIM2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_DECALRGB2),
/*
 * ?
    DEFINE_NAMED_COMBINE_MODE(G_CC_DECALRGBA2),
*/
    DEFINE_NAMED_COMBINE_MODE(G_CC_BLENDI2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_BLENDIA2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_CHROMA_KEY2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_HILITERGB2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_HILITERGBA2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_HILITERGBDECALA2),
    DEFINE_NAMED_COMBINE_MODE(G_CC_HILITERGBPASSA2),
};

bool combineModeWithName(const std::string& name, ColorCombineMode& result) {
    auto it = gNamedCombineModes.find(name);

    if (it == gNamedCombineModes.end()) {
        return false;
    }

    result = it->second;

    return true;
}